Hooks:PostHook(PlayerManager, "check_skills", "init_exp_on_kill", function(self)
	self._total_xp_gained_on_kill = nil
	self._message_system:unregister(Message.OnEnemyKilled, "_exp_on_kill")
	self._message_system:register(Message.OnEnemyKilled, "_exp_on_kill", callback(self, self, "_do_exp_on_kill"))
end)

function PlayerManager:_exp_gain_manage(ui)
	local cdiff = Global.game_settings and Global.game_settings.difficulty or "normal"
	local base_exp = 12
	local diff_mul = {
		easy = 1,
        normal = 1,
        hard = 69696969,
        overkill = 1.1,
        overkill_145 = 1.5,
        easy_wish = 2,
        overkill_290 = 2.8,
        sm_wish = 3.5
    }

	base_exp = base_exp * diff_mul[cdiff]

	local diff_soft_cap = {
		easy = 1200,
        normal = 1200,
        hard = 120000000000000000000000,
        overkill = 1400,
        overkill_145 = 2300,
        easy_wish = 3000,
        overkill_290 = 4200,
        sm_wish = 5200
	}

	if self._total_xp_gained_on_kill and self._total_xp_gained_on_kill > diff_soft_cap[cdiff] and EXPOK._data.gain_exp_on_kills then
		local soft_cap = 0.9 - ((self._total_xp_gained_on_kill - diff_soft_cap[cdiff]) / self._total_xp_gained_on_kill)
		base_exp = base_exp * soft_cap
	end

	base_exp = math.max(base_exp, 1)

	if not ui then
		self._total_xp_gained_on_kill = (self._total_xp_gained_on_kill or 0) + base_exp
	end

	return base_exp
end

function PlayerManager:_delayed_clbk_remove_bonus()
	DelayedCalls:Add("bonus_anim", self:get_temporary_property("bonus_xp_special_killed"), function()
		managers.hud:_force_remove_bonus_xp()
		managers.hud:_force_remove_bonus_modern()
	end)
end

function PlayerManager:_chk_special_cop_exp_gain(unit)
	local specials = { "heavy_swat_sniper", "sniper", "shield", "marshal_shield", "marshal_shield_break" , "medic", "tank_medic" , "taser" , "spooc", "shadow_spooc" , "phalanx_minion", "phalanx_vip", "drug_lord_boss", "drug_lord_boss_stealth", "ranchmanager", "triad_boss", "triad_boss_no_armor", "deep_boss", "snowman_boss", "piggydozer" , "tank", "tank_mini", "tank_hw" }

	if not unit then
		return false
	end

	if not unit:base() then
		return false
	end

	for i, cop in pairs(specials) do
		if unit:base()._tweak_table and unit:base()._tweak_table == cop then
			self:activate_temporary_property("bonus_xp_special_killed", 10, 10)
			self:_delayed_clbk_remove_bonus()
			return true
		end
	end

	return false
end

function PlayerManager:_killstreak_manage(reset)
	self._killstreak = (self._killstreak or 0) + 1

	if reset then
		self._killstreak = nil
	end

	return self._killstreak
end

function PlayerManager:_do_exp_on_kill(equipped_unit, variant, killed_unit)
    local function _gain_exp(e, v, k_unit)
        local exp = self:_exp_gain_manage()
        local was_special = self:_chk_special_cop_exp_gain(k_unit)
        if not EXPOK._data.gain_exp_on_kills then
            exp = 0
        end

        if was_special or self:has_active_temporary_property("bonus_xp_special_killed") then
            exp = exp * 1.2
        end

        local kills = self:_killstreak_manage()
        if managers.hud and managers.hud._kill_exp then
            managers.hud:_kill_exp(kills, was_special)
        end
        managers.experience:mission_xp_award(exp)
    end

    _gain_exp(equipped_unit, variant, killed_unit)
    self._message_system:unregister(Message.OnEnemyKilled, "_exp_on_kill")
    self._message_system:register(Message.OnEnemyKilled, "_exp_on_kill", _gain_exp)
end